/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.tenant;

import io.naradrama.prologue.domain.tenant.CineroomKey;
import io.naradrama.prologue.domain.tenant.CitizenKey;
import io.naradrama.prologue.domain.tenant.DenizenKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.domain.tenant.TenantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class AudienceKey
extends TenantKey {
    public AudienceKey(String audienceId) {
        super(audienceId, TenantType.Audience);
    }

    public static AudienceKey newKey(DenizenKey DenizenKey2, CineroomKey cineroomKey) {
        return new AudienceKey(AudienceKey.buildMemberKey(DenizenKey2, cineroomKey.getId()));
    }

    public static AudienceKey newKey(String citizenId, String cineroomId) {
        String audienceId = String.format("%s@%s", TenantKey.parseToSequence36(citizenId), cineroomId);
        return new AudienceKey(audienceId);
    }

    public static AudienceKey newKey(CitizenKey citizenKey, CineroomKey cineroomKey) {
        String audienceId = String.format("%s@%s", citizenKey.parseToSequence36(), cineroomKey.getId());
        return new AudienceKey(audienceId);
    }

    public static AudienceKey fromId(String audienceId) {
        return new AudienceKey(audienceId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static AudienceKey fromJson(String json) {
        return JsonUtil.fromJson(json, AudienceKey.class);
    }

    public CitizenKey genCitizenKey() {
        String CitizenKey2 = AudienceKey.buildMemberKey(this.genSequence36(), this.genCineroomKey().genPavilionKey().getId());
        return new CitizenKey(CitizenKey2);
    }

    public CineroomKey genCineroomKey() {
        return new CineroomKey(super.parseToSpaceKey());
    }

    public String genSequence36() {
        return this.parseToSequence36();
    }

    public static AudienceKey sample() {
        return AudienceKey.newKey(DenizenKey.sample(), CineroomKey.sample());
    }

    public static void main(String[] args) {
        System.out.println(AudienceKey.sample().toPrettyJson());
        System.out.println(AudienceKey.sample().genCineroomKey().getId());
        System.out.println(AudienceKey.sample().genSequence36());
        System.out.println(AudienceKey.newKey(CitizenKey.sample(), CineroomKey.sample()));
    }

    public AudienceKey() {
    }
}

