/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.stage;

import io.naradrama.prologue.domain.stage.BackStageKey;
import io.naradrama.prologue.domain.stage.SpaceKey;
import io.naradrama.prologue.domain.stage.SpaceType;
import io.naradrama.prologue.domain.stage.StageChartKey;
import io.naradrama.prologue.domain.tenant.CineroomKey;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class TroupeKey
extends SpaceKey {
    private static final String SPACE_DELIMITER = "-";
    private static final long TROUPE_MAX_SEQUENCE = 36L;

    public TroupeKey(String troupeId) {
        super(troupeId, SpaceType.Troupe);
    }

    protected TroupeKey(String troupeId, SpaceType spaceType) {
        super(troupeId, spaceType);
    }

    public TroupeKey(String stageChartId, long troupeSequence) {
        if (troupeSequence > 36L) {
            throw new IllegalArgumentException("troupeSequence should be less than: 36");
        }
        super.setId(String.format("%s%s%s", stageChartId, SPACE_DELIMITER, Numeral36.getInstance().getStr36(troupeSequence)));
        super.setType(SpaceType.Troupe);
    }

    public TroupeKey(StageChartKey stageChartKey, long troupeSequence) {
        this(stageChartKey.getId(), troupeSequence);
    }

    public static TroupeKey newInstance(String stageChartId, long troupeSequence) {
        return new TroupeKey(stageChartId, troupeSequence);
    }

    public static TroupeKey newInstance(StageChartKey stageChartKey, long troupeSequence) {
        return new TroupeKey(stageChartKey, troupeSequence);
    }

    public static TroupeKey fromId(String troupeId) {
        return new TroupeKey(troupeId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static TroupeKey fromJson(String json) {
        return JsonUtil.fromJson(json, TroupeKey.class);
    }

    public CineroomKey genCineroomKey() {
        String cineroomId = this.genStageChartId();
        return CineroomKey.fromId(cineroomId);
    }

    public BackStageKey genBackStageKey() {
        return new BackStageKey(this.getId());
    }

    public StageChartKey genStageChartKey() {
        return new StageChartKey(this.genStageChartId());
    }

    public String genStageChartId() {
        return this.getId().substring(0, this.getId().indexOf(45));
    }

    public long genSequence() {
        String sequencePart = this.getId().substring(this.getId().indexOf(45) + 1);
        return Numeral36.getInstance().getLong36(sequencePart);
    }

    public static TroupeKey sample() {
        return new TroupeKey(StageChartKey.sample(), 24L);
    }

    public static void main(String[] args) {
        System.out.println(TroupeKey.sample().toPrettyJson());
        System.out.println(TroupeKey.sample().genStageChartId());
        System.out.println(TroupeKey.sample().genCineroomKey());
        System.out.println(TroupeKey.sample().genSequence());
    }

    public TroupeKey() {
    }
}

