/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.stage;

import io.naradrama.prologue.domain.stage.ActorKey;
import io.naradrama.prologue.domain.stage.CastKey;
import io.naradrama.prologue.domain.stage.SpaceKey;
import io.naradrama.prologue.domain.stage.SpaceType;
import io.naradrama.prologue.domain.tenant.AudienceKey;
import io.naradrama.prologue.util.json.JsonUtil;

public class CineasteKey
extends SpaceKey {
    public CineasteKey(AudienceKey audienceKey) {
        super(audienceKey.getId(), SpaceType.Cineaste);
    }

    public CineasteKey(String cineasteId) {
        super(cineasteId, SpaceType.Cineaste);
    }

    public static CineasteKey fromAudienceKey(AudienceKey audienceKey) {
        return new CineasteKey(audienceKey);
    }

    public static CineasteKey fromAudienceId(String audienceId) {
        return new CineasteKey(audienceId);
    }

    public static CineasteKey fromId(String cineasteId) {
        return new CineasteKey(cineasteId);
    }

    public ActorKey genActorKey(String castId) {
        return ActorKey.newInstance(castId, this.getId());
    }

    public ActorKey genActorKey(CastKey castKey) {
        return ActorKey.newInstance(castKey.getId(), this.getId());
    }

    public String genAudienceId() {
        return this.genAudienceKey().getId();
    }

    public AudienceKey genAudienceKey() {
        return AudienceKey.fromId(this.getId());
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static CineasteKey fromJson(String json) {
        return JsonUtil.fromJson(json, CineasteKey.class);
    }

    public static CineasteKey sample() {
        return new CineasteKey(AudienceKey.sample());
    }

    public static void main(String[] args) {
        System.out.println(CineasteKey.sample().toPrettyJson());
    }

    public CineasteKey() {
    }
}

