/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.stage;

import io.naradrama.prologue.domain.stage.SpaceKey;
import io.naradrama.prologue.domain.stage.SpaceType;
import io.naradrama.prologue.domain.stage.StageKey;
import io.naradrama.prologue.domain.stage.TroupeKey;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class CastKey
extends SpaceKey {
    private static final long CAST_MAX_SEQUENCE = 36L;

    public CastKey(String castId) {
        super(castId, SpaceType.Cast);
    }

    public CastKey(String troupeId, long castSequence) {
        if (castSequence > 36L) {
            throw new IllegalArgumentException("castSequence should be less than: 36");
        }
        super.setId(String.format("%s%s", troupeId, Numeral36.getInstance().getStr36(castSequence)));
        super.setType(SpaceType.Cast);
    }

    public CastKey(TroupeKey troupeKey, long castSequence) {
        this(troupeKey.getId(), castSequence);
    }

    public static CastKey newInstance(String troupeId, long castSequence) {
        return new CastKey(troupeId, castSequence);
    }

    public static CastKey newInstance(TroupeKey troupeKey, long castSequence) {
        return new CastKey(troupeKey, castSequence);
    }

    public static CastKey fromId(String castId) {
        return new CastKey(castId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static CastKey fromJson(String json) {
        return JsonUtil.fromJson(json, CastKey.class);
    }

    public StageKey genStageKey() {
        return StageKey.fromId(this.getId());
    }

    public String genTroupeId() {
        return this.getId().substring(0, this.getId().length() - 1);
    }

    public TroupeKey genTroupeKey() {
        return new TroupeKey(this.genTroupeId());
    }

    public static CastKey sample() {
        return new CastKey(TroupeKey.sample(), 1L);
    }

    public static void main(String[] args) {
        System.out.println(CastKey.sample().toPrettyJson());
    }

    public CastKey() {
    }
}

