/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.stage;

import io.naradrama.prologue.domain.stage.CastKey;
import io.naradrama.prologue.domain.stage.CineasteKey;
import io.naradrama.prologue.domain.stage.SpaceKey;
import io.naradrama.prologue.domain.stage.SpaceType;
import io.naradrama.prologue.domain.stage.StageKey;
import io.naradrama.prologue.domain.stage.TroupeKey;
import io.naradrama.prologue.domain.tenant.AudienceKey;
import io.naradrama.prologue.domain.tenant.CineroomKey;
import io.naradrama.prologue.domain.tenant.TenantKey;
import io.naradrama.prologue.util.json.JsonUtil;

public class ActorKey
extends SpaceKey {
    public ActorKey(String actorId) {
        super(actorId, SpaceType.Actor);
    }

    public ActorKey(String castId, String cineasteId) {
        this(String.format("%s%s%s", TenantKey.parseToSequence36(cineasteId), "@", castId));
    }

    public ActorKey(CastKey castKey, CineasteKey cineasteKey) {
        this(castKey.getId(), cineasteKey.getId());
    }

    public static ActorKey newInstance(String castId, String cineasteId) {
        return new ActorKey(castId, cineasteId);
    }

    public static ActorKey newInstance(CastKey castKey, CineasteKey cineasteKey) {
        return new ActorKey(castKey, cineasteKey);
    }

    public static ActorKey fromId(String actorId) {
        return new ActorKey(actorId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static ActorKey fromJson(String json) {
        return JsonUtil.fromJson(json, ActorKey.class);
    }

    public StageKey genStageKey() {
        return this.genCastKey().genStageKey();
    }

    public String genCastId() {
        return this.getId().substring(this.getId().indexOf(64) + 1);
    }

    public CastKey genCastKey() {
        return new CastKey(this.genCastId());
    }

    public String genTroupeId() {
        String castId = this.genCastId();
        return castId.substring(0, castId.length() - 1);
    }

    public TroupeKey genTroupeKey() {
        return new TroupeKey(this.genTroupeId());
    }

    public String genCineroomId() {
        return this.genCineroomKey().getId();
    }

    public CineroomKey genCineroomKey() {
        return this.genTroupeKey().genCineroomKey();
    }

    public String genCineasteId() {
        return this.genCineasteKey().getId();
    }

    public CineasteKey genCineasteKey() {
        return CineasteKey.fromId(String.format("%s@%s", TenantKey.parseToSequence36(this.getId()), this.genCineroomKey().getId()));
    }

    public String genAudienceId() {
        return this.genCineasteKey().genAudienceId();
    }

    public AudienceKey genAudienceKey() {
        return this.genCineasteKey().genAudienceKey();
    }

    public static ActorKey sample() {
        return new ActorKey(CastKey.sample(), CineasteKey.sample());
    }

    public static void main(String[] args) {
        System.out.println(ActorKey.sample().toPrettyJson());
        System.out.println(ActorKey.sample().genCastId());
        System.out.println(ActorKey.sample().genTroupeId());
        System.out.println(ActorKey.sample().genCineroomKey().toPrettyJson());
        System.out.println(ActorKey.sample().genAudienceId());
    }

    public ActorKey() {
    }
}

