/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class StationServantKey
extends ServantKey {
    private static final String STATION_SERVANT_INITIAL = "SA";

    public StationServantKey(String stationServantId) {
        super(stationServantId, ServantType.StationServant);
    }

    public static StationServantKey newKey() {
        long defaultSequence = 1L;
        return StationServantKey.newKey(defaultSequence);
    }

    public static StationServantKey newKey(long stationSequence) {
        return new StationServantKey(String.format("%s%d", STATION_SERVANT_INITIAL, stationSequence));
    }

    public static StationServantKey fromId(String stationServantId) {
        return new StationServantKey(stationServantId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static StationServantKey fromJson(String json) {
        return JsonUtil.fromJson(json, StationServantKey.class);
    }

    public static StationServantKey sample() {
        return StationServantKey.newKey();
    }

    public static void main(String[] args) {
        System.out.println(StationServantKey.sample().toPrettyJson());
    }

    public StationServantKey() {
    }
}

