/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonUtil;

public class StationKey
extends ServantKey {
    private static final String STATION_INITIAL = "S";

    public StationKey(String stationId) {
        super(stationId, ServantType.Station);
    }

    public static StationKey newKey() {
        long defaultSequence = 1L;
        return StationKey.newKey(defaultSequence);
    }

    public static StationKey newKey(long stationSequence) {
        return new StationKey(String.format("%s%d", STATION_INITIAL, stationSequence));
    }

    public static StationKey fromId(String stationId) {
        return new StationKey(stationId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static StationKey fromJson(String json) {
        return JsonUtil.fromJson(json, StationKey.class);
    }

    public static StationKey sample() {
        return StationKey.newKey();
    }

    public static void main(String[] args) {
        System.out.println(StationKey.sample().toPrettyJson());
    }

    public StationKey() {
    }
}

