/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.domain.office.SquareOfficeKey;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class SquareServantKey
extends ServantKey {
    public SquareServantKey(String squareServantId) {
        super(squareServantId, ServantType.SquareServant);
    }

    public SquareServantKey(SquareOfficeKey squareOfficeKey, long squareServantSequence) {
        this(String.format("%s%s%s", Numeral36.getInstance().getStr36(squareServantSequence), "#", squareOfficeKey.getId()));
    }

    public static SquareServantKey newKey(SquareOfficeKey squareOfficeKey, long squareServantSequence) {
        return new SquareServantKey(squareOfficeKey, squareServantSequence);
    }

    public static SquareServantKey fromId(String squareServantId) {
        return new SquareServantKey(squareServantId);
    }

    public SquareOfficeKey genSquareOfficeKey() {
        return new SquareOfficeKey(this.parseToOfficeKey());
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static SquareServantKey fromJson(String json) {
        return JsonUtil.fromJson(json, SquareServantKey.class);
    }

    public static SquareServantKey sample() {
        return new SquareServantKey(SquareOfficeKey.sample(), 1L);
    }

    public static void main(String[] args) {
        System.out.println(SquareServantKey.sample().toPrettyJson());
        System.out.println(SquareServantKey.sample().genSquareOfficeKey().toPrettyJson());
    }

    public SquareServantKey() {
    }
}

