/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonSerializable;
import java.util.Objects;

public abstract class ServantKey
implements JsonSerializable {
    public static final String SERVANT_DELIMITER = "#";
    private String id;
    private ServantType type;

    protected ServantKey(String id, ServantType type) {
        this.id = id;
        this.type = type;
    }

    protected ServantKey(ServantKey servantKey) {
        this.id = servantKey.getId();
        this.type = servantKey.getType();
    }

    protected String parseToOfficeKey() {
        if (!this.id.contains(SERVANT_DELIMITER)) {
            return this.id;
        }
        return this.id.substring(this.id.lastIndexOf(SERVANT_DELIMITER) + 1);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target != null && this.getClass() == target.getClass()) {
            ServantKey key = (ServantKey)target;
            return Objects.equals(this.id, key.getId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.toJson();
    }

    public String getId() {
        return this.id;
    }

    public ServantType getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(ServantType type) {
        this.type = type;
    }

    public ServantKey() {
    }
}

