/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.PavilionOfficeKey;
import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class PavilionServantKey
extends ServantKey {
    public PavilionServantKey(String pavilionServantId) {
        super(pavilionServantId, ServantType.PavilionServant);
    }

    public PavilionServantKey(PavilionOfficeKey pavilionOfficeKey, long pavilionServantSequence) {
        this(String.format("%s%s%s", Numeral36.getInstance().getStr36(pavilionServantSequence), "#", pavilionOfficeKey.getId()));
    }

    public static PavilionServantKey newKey(PavilionOfficeKey pavilionOfficeKey, long pavilionServantSequence) {
        return new PavilionServantKey(pavilionOfficeKey, pavilionServantSequence);
    }

    public static PavilionServantKey fromId(String pavilionServantId) {
        return new PavilionServantKey(pavilionServantId);
    }

    public PavilionOfficeKey genPavilionOfficeKey() {
        return new PavilionOfficeKey(this.parseToOfficeKey());
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static PavilionServantKey fromJson(String json) {
        return JsonUtil.fromJson(json, PavilionServantKey.class);
    }

    public static PavilionServantKey sample() {
        return new PavilionServantKey(PavilionOfficeKey.sample(), 1L);
    }

    public static void main(String[] args) {
        System.out.println(PavilionServantKey.sample().toPrettyJson());
        System.out.println(PavilionServantKey.sample().genPavilionOfficeKey().toPrettyJson());
    }

    public PavilionServantKey() {
    }
}

