/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.CineroomOfficeKey;
import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class CineroomServantKey
extends ServantKey {
    public CineroomServantKey(String cineroomServantId) {
        super(cineroomServantId, ServantType.CineroomServant);
    }

    public CineroomServantKey(CineroomOfficeKey cineroomOfficeKey, long cineroomServantSequence) {
        this(String.format("%s%s%s", Numeral36.getInstance().getStr36(cineroomServantSequence), "#", cineroomOfficeKey.getId()));
    }

    public static CineroomServantKey newKey(CineroomOfficeKey cineroomOfficeKey, long cineroomServantSequence) {
        return new CineroomServantKey(cineroomOfficeKey, cineroomServantSequence);
    }

    public static CineroomServantKey fromId(String cineroomServantId) {
        return new CineroomServantKey(cineroomServantId);
    }

    public CineroomOfficeKey genCineroomOfficeKey() {
        return new CineroomOfficeKey(this.parseToOfficeKey());
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static CineroomServantKey fromJson(String json) {
        return JsonUtil.fromJson(json, CineroomServantKey.class);
    }

    public static CineroomServantKey sample() {
        return new CineroomServantKey(CineroomOfficeKey.sample(), 1L);
    }

    public static void main(String[] args) {
        System.out.println(CineroomServantKey.sample().toPrettyJson());
        System.out.println(CineroomServantKey.sample().genCineroomOfficeKey().toPrettyJson());
    }

    public CineroomServantKey() {
    }
}

