/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.office;

import io.naradrama.prologue.domain.office.ServantKey;
import io.naradrama.prologue.domain.office.ServantType;
import io.naradrama.prologue.domain.stage.BackStageKey;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.numeral36.Numeral36;

public class BackStageServantKey
extends ServantKey {
    public BackStageServantKey(String backStageServantId) {
        super(backStageServantId, ServantType.BackStageServant);
    }

    public BackStageServantKey(BackStageKey backStageKey, long backStageServantSequence) {
        this(String.format("%s%s%s", Numeral36.getInstance().getStr36(backStageServantSequence), "#", backStageKey.getId()));
    }

    public static BackStageServantKey newKey(BackStageKey backStageKey, long backStageServantSequence) {
        return new BackStageServantKey(backStageKey, backStageServantSequence);
    }

    public static BackStageServantKey fromId(String backStageServantId) {
        return new BackStageServantKey(backStageServantId);
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public static BackStageServantKey fromJson(String json) {
        return JsonUtil.fromJson(json, BackStageServantKey.class);
    }

    public static BackStageServantKey sample() {
        return new BackStageServantKey(BackStageKey.sample(), 1L);
    }

    public static void main(String[] args) {
        System.out.println(BackStageServantKey.sample().toPrettyJson());
    }

    public BackStageServantKey() {
    }
}

