/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.lang.LangString;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;

public class LangStrings
implements JsonSerializable {
    private String defaultLanguage;
    private List<LangString> langStrings = new ArrayList<LangString>();

    public LangStrings() {
    }

    protected LangStrings(String langCode, String string) {
        this();
        this.defaultLanguage = langCode;
        this.langStrings.add(LangString.newString(langCode, string));
    }

    public static LangStrings emptyString() {
        return new LangStrings();
    }

    public static LangStrings newString(String landCode, String string) {
        return new LangStrings(landCode, string);
    }

    public static LangStrings newString(String string) {
        return new LangStrings(Locale.getDefault().getLanguage(), string);
    }

    public static LangStrings newString(LangString langString) {
        return new LangStrings(langString.getLanguage(), langString.getString());
    }

    public String toString() {
        return this.toJson();
    }

    public static LangStrings fromJson(String json) {
        return JsonUtil.fromJson(json, LangStrings.class);
    }

    public int size() {
        return this.langStrings.size();
    }

    public List<LangString> list() {
        return this.langStrings;
    }

    public String genString() {
        return this.genString(this.defaultLanguage);
    }

    public String genString(String language) {
        String string = null;
        for (LangString langString : this.langStrings) {
            if (!langString.getLanguage().equals(language)) continue;
            string = langString.getString();
            break;
        }
        if (string == null) {
            for (LangString langString : this.langStrings) {
                if (!langString.getLanguage().equals(this.defaultLanguage)) continue;
                string = langString.getString();
                break;
            }
        }
        if (string == null) {
            throw new NoSuchElementException("language: " + language);
        }
        return string;
    }

    public LangStrings addString(String langCode, String string) {
        this.langStrings.add(LangString.newString(langCode, string));
        return this;
    }

    public LangStrings addString(Locale locale, String string) {
        return this.addString(locale.getLanguage(), string);
    }

    public static LangStrings sample() {
        String langCode = Locale.KOREA.getLanguage();
        LangStrings sample = new LangStrings(langCode, "\ub125\uc2a4\ud2b8\ub9ac");
        sample.addString(Locale.US, "NEXTREE");
        return sample;
    }

    public static void main(String[] args) {
        System.out.println(LangStrings.sample());
        System.out.println(LangStrings.sample().list());
        System.out.println(LangStrings.sample().getDefaultLanguage());
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public List<LangString> getLangStrings() {
        return this.langStrings;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setLangStrings(List<LangString> langStrings) {
        this.langStrings = langStrings;
    }
}

