/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangString
implements JsonSerializable {
    private String language;
    private String string;

    private LangString(Locale locale, String string) {
        this.language = locale.getLanguage();
        this.string = string;
    }

    public static LangString newString(String langCode, String string) {
        return new LangString(langCode, string);
    }

    public static LangString newString(Locale locale, String string) {
        return new LangString(locale.getLanguage(), string);
    }

    public static LangString newString(String string) {
        return new LangString(Locale.getDefault(), string);
    }

    public String toString() {
        return this.toJson();
    }

    public static LangString fromJson(String json) {
        return JsonUtil.fromJson(json, LangString.class);
    }

    public static LangString sample() {
        return new LangString(Locale.KOREA.getLanguage(), "\ud559\uc2b5");
    }

    public static void main(String[] args) {
        System.out.println(LangString.sample());
    }

    public String getLanguage() {
        return this.language;
    }

    public String getString() {
        return this.string;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setString(String string) {
        this.string = string;
    }

    public LangString() {
    }

    public LangString(String language, String string) {
        this.language = language;
        this.string = string;
    }
}

