/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.StringList;
import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangSettings
implements ValueObject {
    private Locale locale;
    private String baseLanguage;
    private StringList supportLanguages;

    public LangSettings(Locale locale, String baseLanguage, StringList supportLanguages) {
        this.locale = locale;
        this.baseLanguage = baseLanguage;
        this.supportLanguages = supportLanguages;
    }

    public LangSettings(String baseLanguage) {
        this(Locale.getDefault(), baseLanguage, StringList.newInstance(baseLanguage));
    }

    public LangSettings(String baseLanguage, StringList supportLanguages) {
        this(Locale.getDefault(), baseLanguage, supportLanguages);
    }

    public String toString() {
        return this.toJson();
    }

    public static LangSettings fromJson(String json) {
        return JsonUtil.fromJson(json, LangSettings.class);
    }

    public static LangSettings sample() {
        Locale locale = Locale.KOREA;
        String name = "\ud37c\ube14\ub9ad\ub098\ub77c\ud50c\ub7ab\ud3fc";
        return new LangSettings(Locale.KOREA.getLanguage(), StringList.newInstance(Locale.KOREA.getLanguage(), Locale.US.getLanguage()));
    }

    public static void main(String[] args) {
        System.out.println(LangSettings.sample().toPrettyJson());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getBaseLanguage() {
        return this.baseLanguage;
    }

    public StringList getSupportLanguages() {
        return this.supportLanguages;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setBaseLanguage(String baseLanguage) {
        this.baseLanguage = baseLanguage;
    }

    public void setSupportLanguages(StringList supportLanguages) {
        this.supportLanguages = supportLanguages;
    }

    public LangSettings() {
    }
}

