/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.StringList;
import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangPreference
implements ValueObject {
    private String defaultLang;
    private StringList supportLangs;

    public LangPreference(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public LangPreference(String defaultLang, StringList supportLangs) {
        this.defaultLang = defaultLang;
        this.supportLangs = supportLangs;
    }

    public String toString() {
        return this.toJson();
    }

    public static LangPreference fromJson(String json) {
        return JsonUtil.fromJson(json, LangPreference.class);
    }

    public static LangPreference systemDefault() {
        return new LangPreference(Locale.getDefault().getLanguage());
    }

    public static LangPreference sample() {
        LangPreference sample = new LangPreference(Locale.US.getLanguage());
        sample.setSupportLangs(StringList.newInstance(Locale.KOREA.getLanguage()));
        return sample;
    }

    public static void main(String[] args) {
        System.out.println(LangPreference.sample().toPrettyJson());
    }

    public String getDefaultLang() {
        return this.defaultLang;
    }

    public StringList getSupportLangs() {
        return this.supportLangs;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void setSupportLangs(StringList supportLangs) {
        this.supportLangs = supportLangs;
    }

    public LangPreference() {
    }
}

