/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.granule.Name;
import io.naradrama.prologue.domain.lang.Lang;
import io.naradrama.prologue.domain.lang.LangName;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LangNames
implements JsonSerializable {
    private String defaultLanguage;
    private Map<String, Name> nameMap = new HashMap<String, Name>();

    public LangNames() {
    }

    private LangNames(LangName langName) {
        this();
        this.defaultLanguage = langName.getLanguage();
        this.nameMap.put(langName.getLanguage(), langName.getName());
    }

    private LangNames(String language, Name name) {
        this();
        this.defaultLanguage = language;
        this.nameMap.put(language, name);
    }

    public static LangNames newName(LangName langName) {
        return new LangNames(langName);
    }

    public static LangNames newName(String language, Name name) {
        return new LangNames(language, name);
    }

    public static LangNames fromJson(String json) {
        return JsonUtil.fromJson(json, LangNames.class);
    }

    public int size() {
        return this.nameMap.size();
    }

    public Name getName(String language) {
        return this.nameMap.get(language);
    }

    public Name genName() {
        return this.nameMap.get(this.defaultLanguage);
    }

    public LangNames addName(String language, Name name) {
        this.nameMap.put(language, name);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LangNames langNames = (LangNames)o;
        return Objects.equals(this.defaultLanguage, langNames.defaultLanguage) && Objects.equals(this.nameMap, langNames.nameMap);
    }

    public int hashCode() {
        return Objects.hash(this.defaultLanguage, this.nameMap);
    }

    public String toString() {
        return this.toJson();
    }

    public LangNames addName(LangName langName) {
        this.nameMap.put(langName.getLanguage(), langName.getName());
        return this;
    }

    public static LangNames sample() {
        LangNames sample = new LangNames(Lang.KOREAN, Name.newFamilyFirst("\uae40", "\uc7ac\uc778"));
        sample.addName(Lang.ENGLISH, Name.newFamilyFirst("Kim", "Jaein"));
        return sample;
    }

    public static void main(String[] args) {
        System.out.println(LangNames.sample());
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Map<String, Name> getNameMap() {
        return this.nameMap;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setNameMap(Map<String, Name> nameMap) {
        this.nameMap = nameMap;
    }
}

