/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Name;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangName
implements ValueObject {
    private String language;
    private Name name;

    public LangName(String language, Name name) {
        this.language = language;
        this.name = name;
    }

    public LangName(Locale locale, Name name) {
        this.language = locale.getLanguage();
        this.name = name;
    }

    public static LangName newGivenFirst(String language, String givenName, String familyName) {
        return new LangName(language, Name.newGivenFirst(givenName, familyName));
    }

    public static LangName newFamilyFirst(String language, String familyName, String givenName) {
        return new LangName(language, Name.newFamilyFirst(familyName, givenName));
    }

    public static LangName sample() {
        Locale locale = Locale.US;
        Name name = Name.sample();
        return new LangName(locale, name);
    }

    public static LangName secondSample() {
        Locale langLocale = Locale.KOREA;
        Name name = Name.sampleFamilyFirst();
        return new LangName(langLocale, name);
    }

    public static LangName fromJson(String json) {
        return JsonUtil.fromJson(json, LangName.class);
    }

    public static void main(String[] args) {
        System.out.println(LangName.sample().toJson());
        System.out.println(LangName.secondSample().toJson());
    }

    public String getLanguage() {
        return this.language;
    }

    public Name getName() {
        return this.name;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public LangName() {
    }
}

