/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LangLabels
implements JsonSerializable {
    private String defaultLanguage;
    private Map<String, String> langLabelMap;

    private LangLabels(String defaultLanguage, String defaultLabel) {
        this.defaultLanguage = defaultLanguage;
        this.langLabelMap = new HashMap<String, String>();
        this.langLabelMap.put(defaultLanguage, defaultLabel);
    }

    public String toString() {
        return this.toJson();
    }

    public static LangLabels fromJson(String json) {
        return JsonUtil.fromJson(json, LangLabels.class);
    }

    public static LangLabels newLabel(String defaultLanguage, String defaultLabel) {
        return new LangLabels(defaultLanguage, defaultLabel);
    }

    public LangLabels addLabel(String langCode, String label) {
        this.langLabelMap.put(langCode, label);
        return this;
    }

    public int countLabel() {
        return this.langLabelMap.size();
    }

    public String getLabel(String langCode) {
        return this.langLabelMap.get(langCode);
    }

    public void removeLabel(String langCode) {
        this.langLabelMap.remove(langCode);
    }

    public static LangLabels sample() {
        String defaultLabel = "Student";
        LangLabels langLabels = LangLabels.newLabel(Locale.US.getLanguage(), defaultLabel);
        langLabels.addLabel(Locale.KOREA.getLanguage(), "\ud559\uc0dd");
        return langLabels;
    }

    public static void main(String[] args) {
        System.out.println(LangLabels.sample());
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public Map<String, String> getLangLabelMap() {
        return this.langLabelMap;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setLangLabelMap(Map<String, String> langLabelMap) {
        this.langLabelMap = langLabelMap;
    }

    public LangLabels() {
    }
}

