/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangLabel
implements JsonSerializable {
    private String lang;
    private String label;

    private LangLabel(Locale locale, String label) {
        this.lang = locale.getLanguage();
        this.label = label;
    }

    public static LangLabel newLabel(String langCode, String label) {
        return new LangLabel(langCode, label);
    }

    public static LangLabel newLabel(Locale locale, String label) {
        return new LangLabel(locale.getLanguage(), label);
    }

    public static LangLabel newLabel(String label) {
        return new LangLabel(Locale.getDefault(), label);
    }

    public String toString() {
        return this.toJson();
    }

    public static LangLabel fromJson(String json) {
        return JsonUtil.fromJson(json, LangLabel.class);
    }

    public static LangLabel sample() {
        return new LangLabel(Locale.KOREA.getLanguage(), "\ud559\uc2b5");
    }

    public static void main(String[] args) {
        System.out.println(LangLabel.sample());
    }

    public String getLang() {
        return this.lang;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LangLabel() {
    }

    public LangLabel(String lang, String label) {
        this.lang = lang;
        this.label = label;
    }
}

