/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.lang;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Address;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class LangAddress
implements ValueObject {
    private String lang;
    private Address address;

    public LangAddress(String lang, Address address) {
        this.lang = lang;
        this.address = address;
    }

    public LangAddress(Locale locale, Address address) {
        this.lang = locale.getLanguage();
        this.address = address;
    }

    public static LangAddress sample() {
        Locale locale = Locale.US;
        Address address = Address.sampleForUs();
        return new LangAddress(locale, address);
    }

    public static LangAddress secondSample() {
        Locale langLocale = Locale.KOREA;
        Address address = Address.sampleForKorea();
        return new LangAddress(langLocale, address);
    }

    public static LangAddress fromJson(String json) {
        return JsonUtil.fromJson(json, LangAddress.class);
    }

    public static void main(String[] args) {
        System.out.println(LangAddress.sample().toJson());
        System.out.println(LangAddress.secondSample().toJson());
    }

    public String getLang() {
        return this.lang;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public LangAddress() {
    }
}

