/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.kollection;

import io.naradrama.prologue.util.json.JsonSerializable;

public class KollectionVersionKey
implements JsonSerializable {
    public static final String DELIMITER = "_";
    private String id;

    public KollectionVersionKey(String kollectionVersionId) {
        this.id = kollectionVersionId;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid key: " + this.id);
        }
    }

    public KollectionVersionKey(String kollectionId, String version) {
        this(String.format("%s%s%s", kollectionId, DELIMITER, version));
    }

    public static KollectionVersionKey fromId(String kollectionVersionId) {
        return new KollectionVersionKey(kollectionVersionId);
    }

    public static KollectionVersionKey newInstance(String kollectionId, String version) {
        return new KollectionVersionKey(kollectionId, version);
    }

    public String genKollectionId() {
        return this.id.substring(0, this.id.indexOf(DELIMITER));
    }

    public String genKollectionVersion() {
        return this.id.substring(this.id.indexOf(DELIMITER) + 1);
    }

    public String toString() {
        return this.toJson();
    }

    private boolean isValid() {
        return !this.id.startsWith(DELIMITER) && !this.id.endsWith(DELIMITER) && this.id.contains(DELIMITER);
    }

    public static KollectionVersionKey sample() {
        KollectionVersionKey sample = KollectionVersionKey.newInstance("namoosori", "1.0.0");
        return sample;
    }

    public static void main(String[] args) {
        KollectionVersionKey sample = KollectionVersionKey.sample();
        System.out.println(sample.toPrettyJson());
        System.out.println("Kollection Id: " + sample.genKollectionId());
        System.out.println("Kollection Version: " + sample.genKollectionVersion());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

