/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.kollection;

import io.naradrama.prologue.domain.kollection.KollectionVersionKey;
import io.naradrama.prologue.util.json.JsonSerializable;

public class KollectieKey
implements JsonSerializable {
    private static final String DELIMITER = "-";
    private String id;

    public KollectieKey(String dramaVersionId) {
        this.id = dramaVersionId;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid key: " + this.id);
        }
    }

    public KollectieKey(String kollectionVersionId, long sequence) {
        this(String.format("%s%s%d", kollectionVersionId, DELIMITER, sequence));
    }

    public static KollectieKey fromId(String dramaVersionId) {
        return new KollectieKey(dramaVersionId);
    }

    public static KollectieKey newInstance(String kollectionVersionId, long sequence) {
        return new KollectieKey(kollectionVersionId, sequence);
    }

    public String genKollectieId() {
        return this.id.substring(0, this.id.indexOf(DELIMITER));
    }

    public String genKollectieSequece() {
        return this.id.substring(this.id.lastIndexOf(DELIMITER) + 1);
    }

    public String genKollectionVersionId() {
        return this.genKollectieId().substring(0, this.id.lastIndexOf(DELIMITER));
    }

    public String genKollectionId() {
        return this.genKollectionVersionId().substring(0, this.id.lastIndexOf("_"));
    }

    public String genKollectionVersion() {
        return this.genKollectionVersionId().substring(this.id.lastIndexOf("_") + 1);
    }

    public String toString() {
        return this.toJson();
    }

    private boolean isValid() {
        return !this.id.startsWith(DELIMITER) && !this.id.endsWith(DELIMITER) && this.id.contains(DELIMITER);
    }

    public static KollectieKey sample() {
        KollectieKey sample = KollectieKey.newInstance(KollectionVersionKey.sample().getId(), 1L);
        return sample;
    }

    public static void main(String[] args) {
        KollectieKey sample = KollectieKey.sample();
        System.out.println(sample.toPrettyJson());
        System.out.println("Kollectie Id: " + sample.genKollectieId());
        System.out.println("Kollectie sequence: " + sample.genKollectieSequece());
        System.out.println("Kollection Id: " + sample.genKollectionId());
        System.out.println("Kollection Version: " + sample.genKollectionVersion());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

