/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.kollection;

import io.naradrama.prologue.util.json.JsonSerializable;

public class DramaVersionKey
implements JsonSerializable {
    private static final String DELIMITER = "_";
    private String id;

    public DramaVersionKey(String dramaVersionId) {
        this.id = dramaVersionId;
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid key: " + this.id);
        }
    }

    public DramaVersionKey(String dramaId, String version) {
        this(String.format("%s%s%s", dramaId, DELIMITER, version));
    }

    public static DramaVersionKey fromId(String dramaVersionId) {
        return new DramaVersionKey(dramaVersionId);
    }

    public static DramaVersionKey newInstance(String dramaId, String version) {
        return new DramaVersionKey(dramaId, version);
    }

    public String genDramaId() {
        return this.id.substring(0, this.id.indexOf(DELIMITER));
    }

    public String genDramaVersion() {
        return this.id.substring(this.id.indexOf(DELIMITER) + 1);
    }

    public String toString() {
        return this.toJson();
    }

    private boolean isValid() {
        return !this.id.startsWith(DELIMITER) && !this.id.endsWith(DELIMITER) && this.id.contains(DELIMITER);
    }

    public static DramaVersionKey sample() {
        DramaVersionKey sample = DramaVersionKey.newInstance("timecard", "1.0.0");
        return sample;
    }

    public static void main(String[] args) {
        DramaVersionKey sample = DramaVersionKey.sample();
        System.out.println(sample.toPrettyJson());
        System.out.println("Drama Id: " + sample.genDramaId());
        System.out.println("Drama Version: " + sample.genDramaVersion());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

