/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Role;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RoleList
implements ValueObject {
    private List<Role> roles = new ArrayList<Role>();

    private RoleList() {
    }

    public String toString() {
        return this.toJson();
    }

    public static RoleList fromJson(String json) {
        return JsonUtil.fromJson(json, RoleList.class);
    }

    public static RoleList newInstance(Role role) {
        RoleList referenceRoles = new RoleList();
        referenceRoles.getRoles().add(role);
        return referenceRoles;
    }

    public static RoleList newInstance() {
        return new RoleList();
    }

    public RoleList add(Role role) {
        this.roles.add(role);
        return this;
    }

    public RoleList remove(String key) {
        this.roles.removeIf(role -> role.getKey().equals(key));
        return this;
    }

    public List<Role> list() {
        return this.roles;
    }

    public int size() {
        return this.roles.size();
    }

    public List<String> roleKeys() {
        return this.roles.stream().filter(Objects::nonNull).map(Role::getKey).collect(Collectors.toList());
    }

    public static RoleList sample() {
        RoleList referenceRoles = RoleList.newInstance(new Role("PM", "\ud504\ub85c\uc81d\ud2b8 \uad00\ub9ac\uc790"));
        referenceRoles.add(new Role("QA", "\ud488\uc9c8\uad00\ub9ac\uc790"));
        return referenceRoles;
    }

    public static void main(String[] args) {
        System.out.println(RoleList.sample());
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }
}

