/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Role;
import io.naradrama.prologue.domain.granule.RoleList;
import io.naradrama.prologue.util.json.JsonUtil;

public class RoleBook
implements ValueObject {
    private Role defaultUserRole;
    private RoleList additionalRoles;

    public RoleBook(Role defaultUserRole) {
        this.defaultUserRole = defaultUserRole;
        this.additionalRoles = RoleList.newInstance();
    }

    public String toString() {
        return this.toJson();
    }

    public static RoleBook fromJson(String json) {
        return JsonUtil.fromJson(json, RoleBook.class);
    }

    public static RoleBook defaultBook() {
        Role defaultUserRole = Role.sampleMember();
        return new RoleBook(defaultUserRole);
    }

    public static RoleBook sample() {
        RoleBook sample = new RoleBook(Role.sampleMember());
        sample.getAdditionalRoles().add(new Role("PM", "Project Manager"));
        return sample;
    }

    public static void main(String[] args) {
        System.out.println(RoleBook.sample());
    }

    public Role getDefaultUserRole() {
        return this.defaultUserRole;
    }

    public RoleList getAdditionalRoles() {
        return this.additionalRoles;
    }

    public void setDefaultUserRole(Role defaultUserRole) {
        this.defaultUserRole = defaultUserRole;
    }

    public void setAdditionalRoles(RoleList additionalRoles) {
        this.additionalRoles = additionalRoles;
    }

    public RoleBook() {
    }

    public RoleBook(Role defaultUserRole, RoleList additionalRoles) {
        this.defaultUserRole = defaultUserRole;
        this.additionalRoles = additionalRoles;
    }
}

