/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.granule.Phone;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class PhoneList
implements JsonSerializable {
    private List<Phone> phones = new ArrayList<Phone>();

    public PhoneList() {
    }

    public PhoneList(Phone phone) {
        this();
        this.phones.add(phone);
    }

    public static PhoneList newPhone(Phone phone) {
        return new PhoneList(phone);
    }

    public String toString() {
        return this.toJson();
    }

    public static PhoneList fromJson(String json) {
        return JsonUtil.fromJson(json, PhoneList.class);
    }

    public static PhoneList sample() {
        return new PhoneList(Phone.mobileSample());
    }

    public PhoneList add(Phone phone) {
        this.phones.add(phone);
        return this;
    }

    public PhoneList add(String countryCode, String carrierCode, String fullNumber) {
        Phone newPhone = new Phone(countryCode, carrierCode, fullNumber);
        this.phones.add(newPhone);
        return this;
    }

    public void addAll(List<Phone> phones) {
        this.phones.addAll(phones);
    }

    public List<Phone> list() {
        return this.phones;
    }

    public PhoneList remove(Phone phone) {
        this.getPhones().removeIf(comparePhone -> this.equals(phone));
        return this;
    }

    public Phone genFirst() {
        if (this.phones == null || this.phones.isEmpty()) {
            return null;
        }
        return this.phones.get(0);
    }

    public boolean contains(String fullNumber) {
        for (Phone phone : this.phones) {
            if (!phone.genFullNumber().equals(fullNumber)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String fullNumber) {
        int i = 0;
        for (Phone phone : this.phones) {
            if (phone.genFullNumber().equals(fullNumber)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public PhoneList remove(String fullNumber) {
        int index = this.indexOf(fullNumber);
        if (index != -1) {
            this.phones.remove(index);
        }
        return this;
    }

    public int size() {
        return this.phones.size();
    }

    public static void main(String[] args) {
        System.out.println(PhoneList.sample());
        System.out.println(PhoneList.sample().toJson());
        System.out.println(PhoneList.fromJson(PhoneList.sample().toJson()));
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }
}

