/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;

public class Phone
implements ValueObject {
    private String countryCode;
    private String carrierCode;
    private String frontNumber;
    private String backNumber;
    private String displayNumber;

    public Phone(String countryCode, String carrierCode, String fullNumber) {
        this(countryCode, carrierCode, fullNumber.substring(0, fullNumber.length() - 4), fullNumber.substring(fullNumber.length() - 4));
    }

    public Phone(String countryCode, String carrierCode, String frontNumber, String backNumber) {
        this.countryCode = countryCode;
        this.carrierCode = carrierCode.startsWith("0") ? carrierCode.substring(1) : carrierCode;
        this.frontNumber = frontNumber;
        this.backNumber = backNumber;
        this.displayNumber = String.format("+%s %d-%s-%s", countryCode, Integer.valueOf(carrierCode), frontNumber, backNumber);
    }

    public String toString() {
        return this.toJson();
    }

    public static Phone mobileSample() {
        String countryCode = "82";
        String carrierCode = "010";
        String frontNumber = "1235";
        String backNumber = "3903";
        return new Phone(countryCode, carrierCode, frontNumber, backNumber);
    }

    public static Phone officeSample() {
        String countryCode = "82";
        String carrierCode = "010";
        String frontNumber = "6408";
        String backNumber = "6617";
        return new Phone(countryCode, carrierCode, frontNumber, backNumber);
    }

    public static Phone fromJson(String json) {
        return JsonUtil.fromJson(json, Phone.class);
    }

    public String genFullNumber() {
        return String.format("+%s%s%s%s", this.countryCode, this.carrierCode, this.frontNumber, this.backNumber);
    }

    public String genFullNumberOnly() {
        return String.format("%s%s%s%s", this.countryCode, this.carrierCode, this.frontNumber, this.backNumber);
    }

    public String genCommonNumber() {
        return String.format("%s-%s-%s", this.countryCode, this.carrierCode, this.frontNumber, this.backNumber);
    }

    public static void main(String[] args) {
        System.out.println(Phone.mobileSample().getDisplayNumber());
        System.out.println(Phone.officeSample().genFullNumber());
        System.out.println(Phone.officeSample().genFullNumberOnly());
        System.out.println(Phone.officeSample().genCommonNumber());
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCarrierCode() {
        return this.carrierCode;
    }

    public String getFrontNumber() {
        return this.frontNumber;
    }

    public String getBackNumber() {
        return this.backNumber;
    }

    public String getDisplayNumber() {
        return this.displayNumber;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public void setFrontNumber(String frontNumber) {
        this.frontNumber = frontNumber;
    }

    public void setBackNumber(String backNumber) {
        this.backNumber = backNumber;
    }

    public void setDisplayNumber(String displayNumber) {
        this.displayNumber = displayNumber;
    }

    public Phone() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Phone)) {
            return false;
        }
        Phone other = (Phone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$carrierCode = this.getCarrierCode();
        String other$carrierCode = other.getCarrierCode();
        if (this$carrierCode == null ? other$carrierCode != null : !this$carrierCode.equals(other$carrierCode)) {
            return false;
        }
        String this$frontNumber = this.getFrontNumber();
        String other$frontNumber = other.getFrontNumber();
        if (this$frontNumber == null ? other$frontNumber != null : !this$frontNumber.equals(other$frontNumber)) {
            return false;
        }
        String this$backNumber = this.getBackNumber();
        String other$backNumber = other.getBackNumber();
        if (this$backNumber == null ? other$backNumber != null : !this$backNumber.equals(other$backNumber)) {
            return false;
        }
        String this$displayNumber = this.getDisplayNumber();
        String other$displayNumber = other.getDisplayNumber();
        return !(this$displayNumber == null ? other$displayNumber != null : !this$displayNumber.equals(other$displayNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Phone;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $carrierCode = this.getCarrierCode();
        result = result * 59 + ($carrierCode == null ? 43 : $carrierCode.hashCode());
        String $frontNumber = this.getFrontNumber();
        result = result * 59 + ($frontNumber == null ? 43 : $frontNumber.hashCode());
        String $backNumber = this.getBackNumber();
        result = result * 59 + ($backNumber == null ? 43 : $backNumber.hashCode());
        String $displayNumber = this.getDisplayNumber();
        result = result * 59 + ($displayNumber == null ? 43 : $displayNumber.hashCode());
        return result;
    }
}

