/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.IdName;
import io.naradrama.prologue.domain.granule.NotieType;
import io.naradrama.prologue.domain.tenant.DenizenKey;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;

public class Notification
implements JsonSerializable {
    private String denizenId;
    private String title;
    private NotieType notieType;
    private String message;
    private boolean urgent;
    private IdName drama;
    private IdName sender;
    private String backLink;
    private long time;

    public Notification(String denizenId, String title, NotieType notieType, String message, IdName drama, long time) {
        this(denizenId, title, notieType, message, drama, null, time);
    }

    public Notification(String denizenId, String title, NotieType notieType, String message, IdName drama, IdName sender, long time) {
        this.denizenId = denizenId;
        this.title = title;
        this.notieType = notieType;
        this.message = message;
        this.urgent = false;
        this.drama = drama;
        this.backLink = null;
        this.time = time;
    }

    public String toString() {
        return this.toJson();
    }

    public static Notification fromJson(String json) {
        return JsonUtil.fromJson(json, Notification.class);
    }

    public static Notification sample() {
        String denizenId = DenizenKey.sample().getId();
        String title = "Board Notice";
        String message = "Three comments is added to your post(12379837497). ";
        IdName drama = new IdName("0000", "io.naradrama.survey");
        long time = System.currentTimeMillis();
        Notification sample = new Notification(denizenId, title, NotieType.Message, message, drama, time);
        IdName sender = new IdName(DenizenKey.sample().getId(), "\ud64d\uae38\ub3d9");
        sample.setSender(sender);
        return sample;
    }

    public static void main(String[] args) {
        System.out.println(Notification.sample());
    }

    public String getDenizenId() {
        return this.denizenId;
    }

    public String getTitle() {
        return this.title;
    }

    public NotieType getNotieType() {
        return this.notieType;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public IdName getDrama() {
        return this.drama;
    }

    public IdName getSender() {
        return this.sender;
    }

    public String getBackLink() {
        return this.backLink;
    }

    public long getTime() {
        return this.time;
    }

    public void setDenizenId(String denizenId) {
        this.denizenId = denizenId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNotieType(NotieType notieType) {
        this.notieType = notieType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setUrgent(boolean urgent) {
        this.urgent = urgent;
    }

    public void setDrama(IdName drama) {
        this.drama = drama;
    }

    public void setSender(IdName sender) {
        this.sender = sender;
    }

    public void setBackLink(String backLink) {
        this.backLink = backLink;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Notification() {
    }
}

