/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Name;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class NameList
implements ValueObject {
    private List<Name> names = new ArrayList<Name>();

    public NameList() {
    }

    public NameList(Name name) {
        this();
        this.names.add(name);
    }

    public static NameList newOne(Name name) {
        return new NameList(name);
    }

    public String toString() {
        return this.toJson();
    }

    public static NameList fromJson(String json) {
        return JsonUtil.fromJson(json, NameList.class);
    }

    public NameList add(Name name) {
        this.names.add(name);
        return this;
    }

    public NameList add(String givenName, String familyName) {
        this.names.add(Name.newGivenFirst(givenName, familyName));
        return this;
    }

    public NameList addAll(List<Name> names) {
        this.names.addAll(names);
        return this;
    }

    public List<Name> list() {
        return this.names;
    }

    public NameList remove(Name name) {
        this.getNames().removeIf(compareName -> this.equals(name));
        return this;
    }

    public Name genFirst() {
        if (this.names == null || this.names.isEmpty()) {
            return null;
        }
        return this.names.get(0);
    }

    public int size() {
        return this.names.size();
    }

    public boolean containsByFamilyNameFirst(String familyNameFirst) {
        for (Name name : this.names) {
            if (!name.displayFamilyFirst().equals(familyNameFirst)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String familyNameFirst) {
        int i = 0;
        for (Name name : this.names) {
            if (name.displayFamilyFirst().equals(familyNameFirst)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(String familyNameFirst) {
        int index = this.indexOf(familyNameFirst);
        if (index != -1) {
            this.names.remove(index);
        }
    }

    public static NameList sample() {
        return new NameList(Name.newFamilyFirst(Locale.KOREA, "\uc7a1\uc2a4", "\uc2a4\ud2f0\ube0c")).add(Name.newGivenFirst(Locale.US, "Steve", "Jobs"));
    }

    public static void main(String[] args) {
        System.out.println(NameList.sample());
        System.out.println(NameList.sample().toPrettyJson());
    }

    public List<Name> getNames() {
        return this.names;
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }
}

