/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class Name
implements ValueObject {
    private String language;
    private String givenName;
    private String middleName;
    private String familyName;

    public Name(String givenName, String familyName) {
        this(givenName, null, familyName);
    }

    public Name(Locale locale, String givenName, String familyName) {
        this(locale.getLanguage(), givenName, null, familyName);
    }

    public Name(String givenName, String middleName, String familyName) {
        this(Locale.getDefault().getLanguage(), givenName, middleName, familyName);
    }

    public Name(String language, String givenName, String middleName, String familyName) {
        this.language = language;
        this.givenName = givenName;
        this.middleName = middleName;
        this.familyName = familyName;
    }

    public static Name newGivenFirst(Locale locale, String givenName, String familyName) {
        return new Name(locale, givenName, familyName);
    }

    public static Name newGivenFirst(String givenName, String familyName) {
        return new Name(givenName, familyName);
    }

    public static Name newFamilyFirst(Locale locale, String familyName, String givenName) {
        return new Name(locale, givenName, familyName);
    }

    public static Name newFamilyFirst(String familyName, String givenName) {
        return new Name(givenName, familyName);
    }

    public String displayFamilyFirst() {
        if (this.middleName == null) {
            return String.format("%s %s", this.familyName, this.givenName);
        }
        return String.format("%s %s %s", this.familyName, this.middleName, this.givenName);
    }

    public String displayFamilyLast() {
        if (this.middleName == null) {
            return String.format("%s %s", this.givenName, this.familyName);
        }
        return String.format("%s %s %s", this.givenName, this.middleName, this.familyName);
    }

    public static Name sample() {
        String givenName = "Steve";
        String familyName = "Jobs";
        return new Name(givenName, familyName);
    }

    public static Name sampleWithMiddleName() {
        String givenName = "Steve";
        String middleName = "Paul";
        String familyName = "Jobs";
        return new Name(givenName, middleName, familyName);
    }

    public static Name sampleFamilyFirst() {
        String givenName = "\ud0dc\uc9c4";
        String familyName = "\uae40";
        return new Name(givenName, familyName);
    }

    public static Name sampleFamilyLast() {
        return Name.sample();
    }

    public String toString() {
        return this.toJson();
    }

    public static Name fromJson(String json) {
        return JsonUtil.fromJson(json, Name.class);
    }

    public static void main(String[] args) {
        System.out.println(Name.sample().toJson());
        System.out.println(Name.sample().displayFamilyLast());
        System.out.println(Name.sample().displayFamilyFirst());
        Name name = Name.sample();
        name.setLanguage(Locale.US.getLanguage());
        System.out.println(name);
        System.out.println(Name.sampleWithMiddleName().displayFamilyLast());
        System.out.println(Name.sampleWithMiddleName().displayFamilyFirst());
        System.out.println(Name.sampleWithMiddleName().displayFamilyFirst().replace(" ", "%20%20"));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public Name() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$givenName = this.getGivenName();
        String other$givenName = other.getGivenName();
        if (this$givenName == null ? other$givenName != null : !this$givenName.equals(other$givenName)) {
            return false;
        }
        String this$middleName = this.getMiddleName();
        String other$middleName = other.getMiddleName();
        if (this$middleName == null ? other$middleName != null : !this$middleName.equals(other$middleName)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        return !(this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Name;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $givenName = this.getGivenName();
        result = result * 59 + ($givenName == null ? 43 : $givenName.hashCode());
        String $middleName = this.getMiddleName();
        result = result * 59 + ($middleName == null ? 43 : $middleName.hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        return result;
    }
}

