/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.string.StringUtil;
import java.util.Locale;

public class LocaledName
implements ValueObject {
    private String langCode;
    private String familyName;
    private String middleName;
    private String firstName;

    public LocaledName(String familyName, String givenName) {
        this(Locale.getDefault(), familyName, givenName);
    }

    public LocaledName(Locale langLocale, String familyName, String firstName) {
        this(langLocale.getLanguage(), familyName, firstName);
    }

    public LocaledName(String langCode, String familyName, String firstName) {
        this.langCode = langCode;
        this.familyName = familyName;
        this.firstName = firstName;
    }

    public static LocaledName sample() {
        Locale langLocale = Locale.getDefault();
        String familyName = "\uae40";
        String firstName = "\ucca0\uc218";
        return new LocaledName(langLocale, familyName, firstName);
    }

    public static LocaledName getEnglishSample() {
        Locale langLocale = Locale.ENGLISH;
        String familyName = "Kim";
        String givenName = "Chulsu";
        return new LocaledName(langLocale, familyName, givenName);
    }

    public static LocaledName fromJson(String json) {
        return JsonUtil.fromJson(json, LocaledName.class);
    }

    public String getDisplayName() {
        String displayFamilyName = StringUtil.defaultString((String)this.familyName);
        String displayGivenName = StringUtil.defaultString((String)this.firstName);
        if (this.langCode.equals("ko")) {
            return String.format("%s%s", displayFamilyName, displayGivenName);
        }
        return String.format("%s %s", displayGivenName, displayFamilyName);
    }

    public String getFullName() {
        if (this.middleName == null || this.middleName.equals("")) {
            return this.getDisplayName();
        }
        return String.format("%s %s %s", this.firstName, this.middleName, this.familyName);
    }

    public String getGivenName() {
        return this.firstName;
    }

    public static void main(String[] args) {
        System.out.println(LocaledName.sample());
    }

    public String getLangCode() {
        return this.langCode;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public LocaledName() {
    }
}

