/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.granule.Email;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class EmailList
implements JsonSerializable {
    private List<Email> emails = new ArrayList<Email>();

    public EmailList() {
    }

    public EmailList(Email email) {
        this();
        this.add(email);
    }

    public static EmailList newEmail(Email email) {
        return new EmailList(email);
    }

    public static EmailList list() {
        return new EmailList();
    }

    public String toString() {
        return this.toJson();
    }

    public static EmailList sample() {
        EmailList sample = new EmailList();
        sample.add(Email.sample());
        return sample;
    }

    public static EmailList fromJson(String json) {
        return JsonUtil.fromJson(json, EmailList.class);
    }

    public EmailList add(Email email) {
        this.emails.add(email);
        return this;
    }

    public void addAll(List<Email> emails) {
        for (Email email : emails) {
            this.add(email);
        }
    }

    public EmailList remove(Email email) {
        this.getEmails().removeIf(compareEmail -> this.equals(email));
        return this;
    }

    public Email genFirst() {
        if (this.emails == null || this.emails.isEmpty()) {
            return null;
        }
        return this.emails.get(0);
    }

    public Email get(String targetEmail) {
        Email foundEmail = null;
        for (Email email : this.emails) {
            if (!email.getEmail().equals(targetEmail)) continue;
            foundEmail = email;
            break;
        }
        return foundEmail;
    }

    public boolean contains(String targetEmail) {
        for (Email email : this.emails) {
            if (!email.getEmail().equals(targetEmail)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String targetEmail) {
        int i = 0;
        for (Email email : this.emails) {
            if (email.getEmail().equals(targetEmail)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(String targetEmail) {
        int index = this.indexOf(targetEmail);
        if (index != -1) {
            this.emails.remove(index);
        }
    }

    public int size() {
        return this.emails.size();
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public static void main(String[] args) {
        System.out.println(EmailList.sample());
    }
}

