/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.Tier;
import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.util.json.JsonUtil;
import io.naradrama.prologue.util.validation.EmailValidator;

public class Email
implements ValueObject {
    private String email;
    private Tier tier;
    private boolean verified;

    public Email(String email, Tier tier, boolean verified) {
        if (!EmailValidator.isValid(email)) {
            throw new IllegalArgumentException("Invalid email: " + email);
        }
        this.email = email;
        this.tier = tier;
        this.verified = verified;
    }

    public Email(String email, Tier tier) {
        this(email, tier, false);
    }

    public Email(String email) {
        this(email, Tier.Primary, false);
    }

    public static Email newPrimary(String email) {
        return new Email(email, Tier.Primary, false);
    }

    public static Email newSecondary(String email) {
        return new Email(email, Tier.Secondary, false);
    }

    public static Email newVerifiedPrimary(String email) {
        return new Email(email, Tier.Primary, true);
    }

    public static Email newVerifiedSecondary(String email) {
        return new Email(email, Tier.Secondary, true);
    }

    public String toString() {
        return this.toJson();
    }

    public static Email fromJson(String json) {
        return JsonUtil.fromJson(json, Email.class);
    }

    public static Email sample() {
        String email = "guest@nara.app";
        return Email.newPrimary(email);
    }

    public static void main(String[] args) {
        System.out.println(Email.sample());
    }

    public String getEmail() {
        return this.email;
    }

    public Tier getTier() {
        return this.tier;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public Email() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Email)) {
            return false;
        }
        Email other = (Email)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Email;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }
}

