/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.NameValueList;
import io.naradrama.prologue.domain.granule.Address;
import io.naradrama.prologue.domain.granule.Email;
import io.naradrama.prologue.domain.granule.Phone;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;

public class Contact
implements JsonSerializable {
    private String email;
    private String phone;
    private Address address;
    private NameValueList additionalContactMethods;

    public Contact(String email, String phone) {
        this.email = email;
        this.phone = phone;
        this.address = null;
        this.additionalContactMethods = new NameValueList();
    }

    public String toString() {
        return this.toJson();
    }

    public static Contact newEmailPhone(String email, String phone) {
        return new Contact(email, phone);
    }

    public static Contact sample() {
        String email = Email.sample().getEmail();
        String phone = Phone.mobileSample().genFullNumber();
        Contact sample = new Contact(email, phone);
        sample.setAddress(Address.sampleForUs());
        return sample;
    }

    public static Contact fromJson(String json) {
        return JsonUtil.fromJson(json, Contact.class);
    }

    public static void main(String[] args) {
        System.out.println(Contact.sample());
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public Address getAddress() {
        return this.address;
    }

    public NameValueList getAdditionalContactMethods() {
        return this.additionalContactMethods;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setAdditionalContactMethods(NameValueList additionalContactMethods) {
        this.additionalContactMethods = additionalContactMethods;
    }

    public Contact() {
    }
}

