/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.Tier;
import io.naradrama.prologue.domain.granule.Admin;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class AdminList
implements JsonSerializable {
    private final List<Admin> admins = new ArrayList<Admin>();

    public AdminList() {
    }

    public AdminList(Admin admin) {
        this();
        this.admins.add(admin);
    }

    public String toString() {
        return this.toJson();
    }

    public static AdminList sample() {
        AdminList sample = new AdminList(Admin.primarySample());
        sample.add(Admin.secondarySample());
        return sample;
    }

    public static AdminList fromJson(String json) {
        return JsonUtil.fromJson(json, AdminList.class);
    }

    public void add(Admin admin) {
        this.admins.add(admin);
    }

    public List<Admin> list() {
        return this.admins;
    }

    public Admin find(String usid) {
        return this.admins.stream().filter(admin -> usid.equals(admin.getUsid())).findFirst().orElse(null);
    }

    public void remove(String usid) {
        Admin admin = this.find(usid);
        if (admin == null) {
            return;
        }
        this.admins.remove(admin);
    }

    public boolean contains(String id) {
        return this.find(id) != null;
    }

    public Admin findPrimary() {
        for (Admin admin : this.admins) {
            if (Tier.Primary != admin.getTier()) continue;
            return admin;
        }
        return null;
    }

    public int size() {
        return this.admins.size();
    }

    public static void main(String[] args) {
        System.out.println(AdminList.sample());
        System.out.println(AdminList.sample().toJson());
        System.out.println(AdminList.fromJson(AdminList.sample().toJson()));
    }
}

