/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.Tier;
import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.Name;
import io.naradrama.prologue.util.json.JsonUtil;

public class Admin
implements ValueObject {
    private Tier tier;
    private String usid;
    private String displayName;
    private Name name;
    private String email;
    private String phone;

    private Admin(String usid, Name name, String email) {
        this.usid = usid;
        this.name = name;
        this.displayName = name.displayFamilyFirst();
        this.email = email;
    }

    public static Admin primary(String usid, Name name, String email) {
        Admin admin = new Admin(usid, name, email);
        admin.setTier(Tier.Primary);
        return admin;
    }

    public static Admin secondary(String usid, Name name, String email) {
        Admin admin = new Admin(usid, name, email);
        admin.setTier(Tier.Secondary);
        return admin;
    }

    public String toString() {
        return this.toJson();
    }

    public static Admin primarySample() {
        String usid = "19-0909882";
        String email = "steve@apple.com";
        Admin sample = Admin.primary(usid, Name.sample(), email);
        sample.setPhone("123-1234-1234");
        return sample;
    }

    public static Admin secondarySample() {
        String usid = "20-1019293";
        String email = "tim@apple.com";
        Admin sample = Admin.secondary(usid, Name.sample(), email);
        sample.setPhone("123-1234-1234");
        return sample;
    }

    public static Admin fromJson(String json) {
        return JsonUtil.fromJson(json, Admin.class);
    }

    public static void main(String[] args) {
        System.out.println(Admin.primarySample());
        System.out.println(Admin.secondarySample());
    }

    public Tier getTier() {
        return this.tier;
    }

    public String getUsid() {
        return this.usid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Name getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public void setUsid(String usid) {
        this.usid = usid;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Admin() {
    }
}

