/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.granule.Address;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;

public class AddressList
implements JsonSerializable {
    private final List<Address> addresses = new ArrayList<Address>();

    public AddressList() {
    }

    public AddressList(Address address) {
        this();
        this.addresses.add(address);
    }

    public String toString() {
        return this.toJson();
    }

    public static AddressList sample() {
        AddressList sample = new AddressList();
        sample.add(Address.sampleForKorea());
        sample.add(Address.sampleForUs());
        return sample;
    }

    public static AddressList fromJson(String json) {
        return JsonUtil.fromJson(json, AddressList.class);
    }

    public void add(Address address) {
        this.addresses.add(address);
    }

    public List<Address> list() {
        return this.addresses;
    }

    public boolean containsByZipCode(String zipCode) {
        boolean found = false;
        for (Address address : this.addresses) {
            if (!address.getZipCode().equals(zipCode)) continue;
            found = true;
            break;
        }
        return found;
    }

    public int indexOf(String zipCode) {
        int i = 0;
        for (Address address : this.addresses) {
            if (address.getZipCode().equals(zipCode)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void remove(String zipCode) {
        int index = this.indexOf(zipCode);
        if (index != -1) {
            this.addresses.remove(index);
        }
    }

    public int size() {
        return this.addresses.size();
    }

    public static void main(String[] args) {
        System.out.println(AddressList.sample());
        System.out.println(AddressList.sample().toJson());
        System.out.println(AddressList.fromJson(AddressList.sample().toJson()));
    }
}

