/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.granule;

import io.naradrama.prologue.domain.ddd.ValueObject;
import io.naradrama.prologue.domain.granule.TinyAddress;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.Locale;

public class Address
implements ValueObject {
    private String language;
    private String country;
    private String zipCode;
    private String zipAddress;
    private String street;
    private String city;
    private String state;

    public Address(String country, String zipCode, String zipAddress, String street) {
        this.language = Locale.getDefault().getLanguage();
        this.country = country;
        this.zipCode = zipCode;
        this.zipAddress = zipAddress;
        this.street = street;
    }

    public Address(String country, String zipCode, String street, String city, String state) {
        this(country, zipCode, null, street);
        this.city = city;
        this.state = state;
    }

    public String toString() {
        return this.toJson();
    }

    public static Address fromJson(String json) {
        return JsonUtil.fromJson(json, Address.class);
    }

    public TinyAddress toTinyAddress() {
        return new TinyAddress(this.zipCode, this.zipAddress, this.street);
    }

    public static Address sample() {
        return new Address("\ub300\ud55c\ubbfc\uad6d", "08503", "\uc11c\uc6b8\uc2dc \uae08\ucc9c\uad6c \uac00\uc0b0\ub514\uc9c0\ud1381\ub85c 171", "\uc5d0\uc2a4\ucf00\uc774\ube0c\uc774\uc6d0\uc13c\ud130 1805");
    }

    public static Address sampleForUs() {
        String country = "U.S.A";
        String zipCode = "06889";
        String street = "12 st.";
        String city = "fairfield";
        String state = "CT";
        Address sample = new Address(country, zipCode, street, city, state);
        sample.setLanguage(Locale.US.getLanguage());
        return sample;
    }

    public static Address sampleForKorea() {
        return Address.sample();
    }

    public static void main(String[] args) {
        System.out.println(Address.sampleForKorea());
        System.out.println(Address.sampleForUs());
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getZipAddress() {
        return this.zipAddress;
    }

    public String getStreet() {
        return this.street;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setZipAddress(String zipAddress) {
        this.zipAddress = zipAddress;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Address() {
    }
}

