/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.drama;

import io.naradrama.prologue.domain.ddd.DomainEntity;
import io.naradrama.prologue.domain.stage.ActorKey;

public abstract class StageEntity
extends DomainEntity {
    protected String pavilionId;
    protected String citizenId;
    protected String audienceId;
    protected String actorId;

    protected StageEntity(String id, ActorKey actorKey) {
        super(id);
        this.bindKey(actorKey);
    }

    protected StageEntity(ActorKey actorKey) {
        this.bindKey(actorKey);
    }

    private void bindKey(ActorKey actorKey) {
        this.pavilionId = actorKey.genCineroomKey().genPavilionKey().getId();
        this.citizenId = actorKey.genAudienceKey().genCitizenKey().getId();
        this.audienceId = actorKey.genAudienceId();
        this.actorId = actorKey.getId();
    }

    public String getPavilionId() {
        return this.pavilionId;
    }

    public String getCitizenId() {
        return this.citizenId;
    }

    public String getAudienceId() {
        return this.audienceId;
    }

    public String getActorId() {
        return this.actorId;
    }

    public void setPavilionId(String pavilionId) {
        this.pavilionId = pavilionId;
    }

    public void setCitizenId(String citizenId) {
        this.citizenId = citizenId;
    }

    public void setAudienceId(String audienceId) {
        this.audienceId = audienceId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public StageEntity() {
    }
}

