/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.drama;

import io.naradrama.prologue.domain.ddd.DomainEntity;
import io.naradrama.prologue.domain.tenant.AudienceKey;
import io.naradrama.prologue.domain.tenant.CineroomKey;
import io.naradrama.prologue.domain.tenant.PavilionKey;

public abstract class CineroomEntity
extends DomainEntity {
    private PavilionKey pavilionKey;
    private CineroomKey cineroomKey;
    private long creationTime = System.currentTimeMillis();

    protected CineroomEntity(String id, CineroomKey cineroomKey) {
        super(id);
        this.pavilionKey = cineroomKey.genPavilionKey();
        this.cineroomKey = cineroomKey;
    }

    protected CineroomEntity(String id, AudienceKey audienceKey) {
        super(id);
        this.bindKey(audienceKey);
    }

    protected CineroomEntity(AudienceKey audienceKey) {
        this.bindKey(audienceKey);
    }

    protected CineroomEntity(CineroomKey cineroomKey) {
        this.pavilionKey = cineroomKey.genPavilionKey();
        this.cineroomKey = cineroomKey;
        this.creationTime = System.currentTimeMillis();
    }

    protected CineroomEntity(CineroomEntity sameSpaceEntity) {
        this.pavilionKey = sameSpaceEntity.pavilionKey;
        this.cineroomKey = sameSpaceEntity.cineroomKey;
        this.creationTime = System.currentTimeMillis();
    }

    private void bindKey(AudienceKey audienceKey) {
        this.cineroomKey = audienceKey.genCineroomKey();
        this.pavilionKey = this.cineroomKey.genPavilionKey();
    }

    public PavilionKey getPavilionKey() {
        return this.pavilionKey;
    }

    public CineroomKey getCineroomKey() {
        return this.cineroomKey;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setPavilionKey(PavilionKey pavilionKey) {
        this.pavilionKey = pavilionKey;
    }

    public void setCineroomKey(CineroomKey cineroomKey) {
        this.cineroomKey = cineroomKey;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public CineroomEntity() {
    }
}

