/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.ddd;

import io.naradrama.prologue.domain.IdName;
import io.naradrama.prologue.domain.NameValueList;
import io.naradrama.prologue.util.json.JsonSerializable;
import java.util.Objects;
import java.util.UUID;

public abstract class DomainEntity
implements JsonSerializable {
    private String id;
    private long entityVersion;
    private long registrationTime;
    private long modificationTime;

    protected DomainEntity() {
        this.id = UUID.randomUUID().toString();
        this.registrationTime = System.currentTimeMillis();
    }

    protected DomainEntity(String id) {
        this.id = id;
        this.registrationTime = System.currentTimeMillis();
    }

    protected DomainEntity(DomainEntity domainEntity) {
        this.id = domainEntity.getId();
        this.entityVersion = domainEntity.getEntityVersion();
    }

    public IdName genEntityIdName() {
        return new IdName(this.id, this.getClass().getSimpleName());
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target == null || this.getClass() != target.getClass()) {
            return false;
        }
        DomainEntity entity = (DomainEntity)target;
        return Objects.equals(this.id, entity.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.toJson();
    }

    public void modify(NameValueList nameValues) {
        this.modifyAttributes(nameValues);
        this.modificationTime = System.currentTimeMillis();
    }

    protected abstract void modifyAttributes(NameValueList var1);

    public String getId() {
        return this.id;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public long getRegistrationTime() {
        return this.registrationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEntityVersion(long entityVersion) {
        this.entityVersion = entityVersion;
    }

    public void setRegistrationTime(long registrationTime) {
        this.registrationTime = registrationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }
}

