/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.query.dynamic;

import io.naradrama.prologue.domain.cqrs.query.dynamic.Connector;
import io.naradrama.prologue.domain.cqrs.query.dynamic.Operator;
import io.naradrama.prologue.domain.cqrs.query.dynamic.QueryParam;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QueryParams
implements JsonSerializable {
    private final List<Operator> specialOperator = Arrays.asList(Operator.Like, Operator.In, Operator.NotIn);
    private List<QueryParam> queryParams = new ArrayList<QueryParam>();

    public static QueryParams newInstance() {
        return new QueryParams();
    }

    public static QueryParams newInstance(QueryParam queryParam) {
        return new QueryParams().add(queryParam);
    }

    public static QueryParams newInstance(List<QueryParam> queryParams) {
        return new QueryParams().addAll(queryParams);
    }

    public QueryParams add(QueryParam queryParam) {
        this.queryParams.add(queryParam);
        return this;
    }

    public QueryParams addAll(List<QueryParam> queryParams) {
        this.queryParams.addAll(queryParams);
        return this;
    }

    public String toSqlString() {
        StringBuilder rsql = new StringBuilder();
        this.queryParams.stream().forEach(queryParam -> {
            rsql.append(queryParam.getFieldName());
            rsql.append(queryParam.getOperation().operationString());
            if (this.specialOperator.contains((Object)queryParam.getOperation())) {
                rsql.append(this.parseValue(queryParam.getOperation(), queryParam.getValue()));
            } else {
                rsql.append(queryParam.getValue());
            }
            rsql.append(queryParam.getConnector().connectorString());
        });
        String result = rsql.toString().trim();
        if (result.endsWith(Connector.And.connectorString()) || result.endsWith(Connector.Or.connectorString())) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private String parseValue(Operator operator, String value) {
        String parsedQueryValues = "";
        String inQueryValues = value.trim();
        switch (operator) {
            case Like: {
                String regex = ".*";
                inQueryValues = regex.concat(inQueryValues);
                parsedQueryValues = inQueryValues.concat(regex);
                break;
            }
            case In: 
            case NotIn: {
                inQueryValues = inQueryValues.replaceAll("\"", "");
                inQueryValues = inQueryValues.replace("[", "(");
                parsedQueryValues = inQueryValues.replace("]", ")");
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator: " + operator.operationString());
            }
        }
        return parsedQueryValues;
    }

    public String toString() {
        return this.toJson();
    }

    public static QueryParams fromJson(String json) {
        return JsonUtil.fromJson(json, QueryParams.class);
    }

    public static QueryParams sample() {
        QueryParams queryParams = QueryParams.newInstance();
        queryParams.add(new QueryParam("memberName", Operator.Equal, "Steve", Connector.And));
        queryParams.add(new QueryParam("memberAge", Operator.GreaterThan, "10", Connector.End));
        return queryParams;
    }

    public static void main(String[] args) {
        String sample = "[\"first\", \"second\"]";
        QueryParams queryParams = new QueryParams();
        queryParams.setQueryParams(Arrays.asList(new QueryParam("fieldName", Operator.In, "name", Connector.End)));
        String json = queryParams.toJson();
        System.out.println(QueryParams.fromJson(json).toJson());
    }

    public List<Operator> getSpecialOperator() {
        return this.specialOperator;
    }

    public List<QueryParam> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(List<QueryParam> queryParams) {
        this.queryParams = queryParams;
    }
}

