/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.query.dynamic;

import io.naradrama.prologue.domain.cqrs.query.dynamic.Connector;
import io.naradrama.prologue.domain.cqrs.query.dynamic.Operator;
import io.naradrama.prologue.util.json.JsonSerializable;

public class QueryParam
implements JsonSerializable {
    private String fieldName;
    private Operator operation;
    private String value;
    private Connector connector;

    public String toSqlString() {
        StringBuilder rsql = new StringBuilder();
        rsql.append(this.fieldName);
        rsql.append(this.operation.operationString());
        rsql.append(this.value);
        rsql.append(this.connector.connectorString());
        return rsql.toString().trim();
    }

    public static QueryParam sample() {
        String fieldName = "memberName";
        Operator operator = Operator.Equal;
        String value = "Steve";
        Connector connector = Connector.End;
        return new QueryParam(fieldName, operator, value, connector);
    }

    public static void main(String[] args) {
        System.out.println(QueryParam.sample().toPrettyJson());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Operator getOperation() {
        return this.operation;
    }

    public String getValue() {
        return this.value;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setOperation(Operator operation) {
        this.operation = operation;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public QueryParam() {
    }

    public QueryParam(String fieldName, Operator operation, String value, Connector connector) {
        this.fieldName = fieldName;
        this.operation = operation;
        this.value = value;
        this.connector = connector;
    }
}

