/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.query;

import io.naradrama.prologue.domain.Offset;
import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.UUID;

public class QueryResponse<T>
implements JsonSerializable {
    private T queryResult;
    private Offset offset;
    private boolean requestFailed;
    private FailureMessage failureMessage;

    public QueryResponse(T queryResult) {
        this.queryResult = queryResult;
    }

    public QueryResponse(Offset offset) {
        this.offset = offset;
    }

    public QueryResponse(FailureMessage failureMessage) {
        this.failureMessage = failureMessage;
        this.requestFailed = true;
    }

    public void setFailureMessage(FailureMessage failureMessage) {
        this.failureMessage = failureMessage;
        this.requestFailed = true;
    }

    public String toString() {
        return this.toJson();
    }

    public static QueryResponse fromJson(String json) {
        return JsonUtil.fromJson(json, QueryResponse.class);
    }

    public static QueryResponse sample() {
        return new QueryResponse<String>(UUID.randomUUID().toString());
    }

    public static void main(String[] args) {
        System.out.println(QueryResponse.sample().toPrettyJson());
    }

    public T getQueryResult() {
        return this.queryResult;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public boolean isRequestFailed() {
        return this.requestFailed;
    }

    public FailureMessage getFailureMessage() {
        return this.failureMessage;
    }

    public void setQueryResult(T queryResult) {
        this.queryResult = queryResult;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public void setRequestFailed(boolean requestFailed) {
        this.requestFailed = requestFailed;
    }

    public QueryResponse() {
    }
}

