/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.query;

import io.naradrama.prologue.domain.cqrs.CqrsExecutable;
import io.naradrama.prologue.domain.cqrs.DomainMessage;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.domain.cqrs.query.CqrsQueryType;
import io.naradrama.prologue.domain.cqrs.query.QueryResponse;
import java.sql.Timestamp;

public abstract class CqrsQuery<T>
extends DomainMessage
implements CqrsExecutable {
    private CqrsQueryType cqrsQueryType;
    private long requestTime;
    private long waitingTime;
    private QueryResponse<T> queryResponse;

    public CqrsQuery(CqrsQueryType cqrsQueryType) {
        super(DomainMessageType.CqrsQuery);
        this.cqrsQueryType = cqrsQueryType;
        this.requestTime = System.currentTimeMillis();
    }

    public CqrsQuery(TraceHeader traceHeader, CqrsQueryType cqrsQueryType) {
        super(traceHeader, DomainMessageType.CqrsQuery);
        this.cqrsQueryType = cqrsQueryType;
        this.requestTime = System.currentTimeMillis();
    }

    public String genRequestTimestamp() {
        return new Timestamp(this.requestTime).toString();
    }

    public String toJsonWithoutResult() {
        T t = this.queryResponse.getQueryResult();
        this.queryResponse.setQueryResult(null);
        String jsonWithoutResult = this.toJson();
        this.queryResponse.setQueryResult(t);
        return jsonWithoutResult;
    }

    @Override
    public void setFailureMessage(FailureMessage failureMessage) {
        if (this.queryResponse == null) {
            this.queryResponse = new QueryResponse(failureMessage);
        } else {
            this.queryResponse.setFailureMessage(failureMessage);
        }
        this.checkWaitingTime();
    }

    public FailureMessage getFailureMessage() {
        return this.queryResponse.getFailureMessage();
    }

    public void setQueryResponse(QueryResponse<T> queryResponse) {
        this.queryResponse = queryResponse;
        this.checkWaitingTime();
    }

    public void setQueryResult(T queryResult) {
        this.queryResponse = new QueryResponse<T>(queryResult);
        this.checkWaitingTime();
    }

    public T getQueryResult() {
        return this.queryResponse.getQueryResult();
    }

    @Override
    public void checkWaitingTime() {
        this.waitingTime = System.currentTimeMillis() - this.requestTime;
    }

    public CqrsQueryType getCqrsQueryType() {
        return this.cqrsQueryType;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public QueryResponse<T> getQueryResponse() {
        return this.queryResponse;
    }

    public void setCqrsQueryType(CqrsQueryType cqrsQueryType) {
        this.cqrsQueryType = cqrsQueryType;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }
}

