/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.query;

import io.naradrama.prologue.domain.Offset;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.domain.cqrs.query.CqrsQuery;
import io.naradrama.prologue.domain.cqrs.query.CqrsQueryType;
import io.naradrama.prologue.domain.cqrs.query.QueryResponse;
import io.naradrama.prologue.domain.cqrs.query.dynamic.QueryParams;

public abstract class CqrsDynamicQuery<T>
extends CqrsQuery<T> {
    private QueryParams queryParams;
    private Offset offset;

    public CqrsDynamicQuery() {
        super(CqrsQueryType.DynamicQuery);
        this.queryParams = QueryParams.newInstance();
        this.setQueryResponse(new QueryResponse(this.offset));
    }

    public CqrsDynamicQuery(TraceHeader traceHeader) {
        super(traceHeader, CqrsQueryType.DynamicQuery);
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
        if (this.getQueryResponse() == null) {
            this.setQueryResponse(new QueryResponse(offset));
        } else {
            this.getQueryResponse().setOffset(offset);
        }
    }

    public String genSqlString() {
        return this.queryParams == null ? "" : this.queryParams.toSqlString();
    }

    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setQueryParams(QueryParams queryParams) {
        this.queryParams = queryParams;
    }
}

