/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.event;

import io.naradrama.prologue.domain.cqrs.DomainMessage;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.domain.cqrs.event.CqrsEventType;
import java.sql.Timestamp;

public abstract class CqrsEvent
extends DomainMessage {
    private CqrsEventType cqrsEventType;
    private String commandId;
    private String producedTimestamp;

    public CqrsEvent() {
        super(DomainMessageType.CqrsEvent);
    }

    public CqrsEvent(CqrsEventType cqrsEventType) {
        super(DomainMessageType.CqrsEvent);
        this.cqrsEventType = cqrsEventType;
        this.producedTimestamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public CqrsEvent(CqrsEventType cqrsEventType, TraceHeader traceHeader) {
        this(cqrsEventType);
        this.setTraceHeader(traceHeader);
        this.producedTimestamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public CqrsEventType getCqrsEventType() {
        return this.cqrsEventType;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public String getProducedTimestamp() {
        return this.producedTimestamp;
    }

    public void setCqrsEventType(CqrsEventType cqrsEventType) {
        this.cqrsEventType = cqrsEventType;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public void setProducedTimestamp(String producedTimestamp) {
        this.producedTimestamp = producedTimestamp;
    }
}

