/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.command;

import io.naradrama.prologue.domain.cqrs.CqrsExecutable;
import io.naradrama.prologue.domain.cqrs.DomainMessage;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.domain.cqrs.TraceHeader;
import io.naradrama.prologue.domain.cqrs.command.CommandResponse;
import io.naradrama.prologue.domain.cqrs.command.CqrsCommandType;
import java.sql.Timestamp;

public abstract class CqrsCommand
extends DomainMessage
implements CqrsExecutable {
    private CqrsCommandType cqrsCommandType;
    private long requestTime;
    private long waitingTime;
    private CommandResponse commandResponse;

    public CqrsCommand(CqrsCommandType cqrsCommandType) {
        super(DomainMessageType.CqrsCommand);
        this.cqrsCommandType = cqrsCommandType;
        this.requestTime = System.currentTimeMillis();
    }

    public CqrsCommand(TraceHeader traceHeader, CqrsCommandType cqrsCommandType) {
        super(traceHeader, DomainMessageType.CqrsCommand);
        this.cqrsCommandType = cqrsCommandType;
        this.requestTime = System.currentTimeMillis();
    }

    public CqrsCommand(String id, TraceHeader traceHeader, CqrsCommandType cqrsCommandType) {
        super(id, traceHeader, DomainMessageType.CqrsCommand);
        this.cqrsCommandType = cqrsCommandType;
        this.requestTime = System.currentTimeMillis();
    }

    public void setCommandResponse(CommandResponse commandResponse) {
        this.commandResponse = commandResponse;
        this.checkWaitingTime();
    }

    public String genRequestTimestamp() {
        return new Timestamp(this.requestTime).toString();
    }

    @Override
    public void setFailureMessage(FailureMessage failureMessage) {
        if (this.commandResponse == null) {
            this.commandResponse = new CommandResponse(failureMessage);
        } else {
            this.commandResponse.setFailureMessage(failureMessage);
        }
        this.checkWaitingTime();
    }

    public FailureMessage getFailureMessage() {
        if (this.commandResponse == null) {
            return null;
        }
        return this.commandResponse.getFailureMessage();
    }

    @Override
    public void checkWaitingTime() {
        this.waitingTime = System.currentTimeMillis() - this.requestTime;
    }

    public CqrsCommandType getCqrsCommandType() {
        return this.cqrsCommandType;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public CommandResponse getCommandResponse() {
        return this.commandResponse;
    }

    public void setCqrsCommandType(CqrsCommandType cqrsCommandType) {
        this.cqrsCommandType = cqrsCommandType;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public void setWaitingTime(long waitingTime) {
        this.waitingTime = waitingTime;
    }
}

