/*
 * Decompiled with CFR 0.152.
 */
package io.naradrama.prologue.domain.cqrs.command;

import io.naradrama.prologue.domain.cqrs.FailureMessage;
import io.naradrama.prologue.util.json.JsonSerializable;
import io.naradrama.prologue.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CommandResponse
implements JsonSerializable {
    private List<String> entityIds;
    private boolean result;
    private boolean requestFailed;
    private FailureMessage failureMessage;

    public CommandResponse(String entityId) {
        ArrayList<String> entityIds = new ArrayList<String>();
        entityIds.add(entityId);
        this.entityIds = entityIds;
    }

    public CommandResponse(FailureMessage failureMessage) {
        this.failureMessage = failureMessage;
        this.requestFailed = true;
    }

    public CommandResponse(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public CommandResponse(boolean result) {
        this.result = result;
    }

    public void setFailureMessage(FailureMessage failureMessage) {
        this.failureMessage = failureMessage;
        this.requestFailed = true;
    }

    public String toString() {
        return this.toJson();
    }

    public static CommandResponse fromJson(String json) {
        return JsonUtil.fromJson(json, CommandResponse.class);
    }

    public static CommandResponse sample() {
        return new CommandResponse(UUID.randomUUID().toString());
    }

    public static void main(String[] args) {
        System.out.println(CommandResponse.sample().toPrettyJson());
    }

    public List<String> getEntityIds() {
        return this.entityIds;
    }

    public boolean isResult() {
        return this.result;
    }

    public boolean isRequestFailed() {
        return this.requestFailed;
    }

    public FailureMessage getFailureMessage() {
        return this.failureMessage;
    }

    public void setEntityIds(List<String> entityIds) {
        this.entityIds = entityIds;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public void setRequestFailed(boolean requestFailed) {
        this.requestFailed = requestFailed;
    }

    public CommandResponse() {
    }
}

